#include <iostream>
#include <bits/stdc++.h>
#include <vector>

using ll = long long;

#define rep(i, n) for (int i = 0; i < n; i++)
#define repi(i, a, b) for (int i = a; i < b; i++)
#define each(i, a) for (auto&i: a)
#define all(a) a.begin(), a.end()
#define vi vector<ll>
#define vvi vector<vi>

using namespace std;

struct Hash{
    ll p, q;
    vi pq, pref, suff;

    ll add(ll a, ll b) {
        ll res = a + b;
        if (res >= q) res += q;
        return res;
    }

    ll sub(ll a, ll b) {
        ll res = a - b;
        if (res < 0) res += q;
        return res;
    }

    ll mul(ll a, ll b) {
        return (a * b) % q;
    }

    Hash(ll n, ll p_, ll q_, string&s) {
        p = p_, q = q_;
        pq.assign(n + 1, 1);
        pref.assign(n + 1, 0);
        suff.assign(n + 1, 0);
        rep(i, n) {
            pref[i + 1] = add(mul(pref[i], p), s[i] - 'a' + 1);
            suff[n - i - 1] = add(mul(suff[n - i], p), s[n - i - 1] - 'a' + 1);
            pq[i + 1] = mul(pq[i], p);
        }
    }

    ll get_hash_pref(ll l, ll r) {
        return sub(pref[r + 1], mul(pref[l], pq[r - l + 1]));
    }

    ll get_hash_suff(ll l, ll r) {
        return sub(pref[l], mul(pref[r + 1], pq[r - l + 1]));
    }
};

ll MAXN = 1100;

bool isintpoly(ll n) {
    ll x = n; string s = "";
    while(x) {
        char c = '0';
        c += (x % 10);
        s = c + s;
        x /= 10;
    }
    string s2 = s;
    reverse(all(s2));
    return s == s2;
}

void solve() {
    ll t; cin >> t;
    vi polys;
    rep(i, MAXN) {
        if (isintpoly(i)) polys.push_back(i);
    }
    vi dp(MAXN, 1);
    rep(i, MAXN) {
        if (isintpoly(i)) dp[i] = 1;
        else {
            dp[i] = 9999999999;
            each(j, polys) {
                if (i - j >= 0)
                    dp[i] = min(dp[i], dp[i - j] + 1);
            }
        }
    }
    rep(_, t) {
        ll n; cin >> n;
        cout << dp[n] << '\n';
    }
}

int main()
{
    ios::sync_with_stdio(0);
    cout.tie(0);
    cin.tie(0);

    ll t = 1; // cin >> t;
    rep(_, t) {
        solve();
    }
}
